/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef RLTB_TRACEBUFFERCONFIG_H_
#define RLTB_TRACEBUFFERCONFIG_H_

#ifndef __cplusplus
	#include <stdbool.h>
#endif

typedef struct
{
	bool PortA;
	bool PortB;
	bool PortC;
	bool PortDLow;
	bool PortDHigh;
	bool PortELow;
	bool PortEHigh;
	bool PortLaserIn;
	bool PortLaserIn0;
	bool PortLaserIn1;
	bool PortLaserOut;
	bool PortLaserOut0;
	bool PortLaserOut1;
	bool PortLaserOut2;
	bool Dac0;
	bool Dac1;
	bool LaserPower16;
	bool LaserPower8;
	bool LaserPower4;
	bool LaserPower2;
	bool LaserPower1;
	bool Fps;
	bool Gate;
	bool Lm;
	bool LaserTriggered;
	bool StartMark;
	bool AbortMark;
} rltbTraceBufferConfig0;

typedef struct
{
	bool Head0TxX;
	bool Head0TxY;
	bool Head0TxZ;
	bool Head0RxX;
	bool Head0RxY;
	bool Head0RxZ;
	bool Head1TxX;
	bool Head1TxY;
	bool Head1TxZ;
	bool Head1RxX;
	bool Head1RxY;
	bool Head1RxZ;
} rltbTraceBufferConfig1;

typedef struct
{
	bool LaserPower0_16;
	bool LaserPower0_8;
	bool LaserPower0_4;
	bool LaserPower0_2;
	bool LaserPower0_1;
	bool LaserPower1_16;
	bool LaserPower1_8;
	bool LaserPower1_4;
	bool LaserPower1_2;
	bool LaserPower1_1;
} rltbTraceBufferConfig2;

typedef struct
{
	bool Spi0Rx;
	bool Spi1Rx;
	bool Spi2Rx;
	bool Spi3Rx;
	bool Quadrature0I;
	bool Quadrature0A;
	bool Quadrature0B;
	bool Quadrature1I;
	bool Quadrature1A;
	bool Quadrature1B;
	bool IOEventChange;
	bool PositionEventChange;
	bool ControlEventChange;
	bool Label;
} rltbTraceBufferConfig3;

typedef struct rltbTraceBufferConfig_Struct
{
	int ConfigVersion;
	rltbTraceBufferConfig0 IOEvents;
	rltbTraceBufferConfig1 PositionEvents;
	rltbTraceBufferConfig2 PowerEvents;
	rltbTraceBufferConfig3 ControlEvents;
} rltbTraceBufferConfig;

#endif // RLTB_TRACEBUFFERCONFIG_H_
